/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.block;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.AnalogBlock;
import DE.siemens.ad.logo.model.AnalogInBlockConnector;
import DE.siemens.ad.logo.model.AnalogOutBlockConnector;
import DE.siemens.ad.logo.model.BinaryInBlockConnector;
import DE.siemens.ad.logo.model.BinaryOutBlockConnector;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.ConstantBlock;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareFactory;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.model.ParameterSetListener;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.hardware.Logo7;
import DE.siemens.ad.logo.util.DifferenceTableModel;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.udf.UDFBlock;
import java.io.IOException;
import java.util.List;

public class DeputyBlock
extends ConstantBlock
implements AnalogBlock {
    private static final long serialVersionUID = 8750795244727154522L;
    private UDFBlock fUDFBlock;
    private boolean fIsInputType;

    public DeputyBlock() {
    }

    public DeputyBlock(WiringDiagram wiringDiagram) {
        super(wiringDiagram);
    }

    protected void initBlockNumber() {
    }

    protected int getDefaultOrder() {
        return 0;
    }

    public int[] getMemoryResources(Hardware hardware) {
        int[] result = new int[HardwareFactory.getInstance().getResourceNames().length];
        return result;
    }

    public String getNumberPrefix() {
        StringBuffer ret = new StringBuffer();
        if (this.getBinaryAnalogType() == 1) {
            ret.append("AD");
        } else {
            ret.append("D");
        }
        if (this.isInputType()) {
            ret.append("I");
        } else {
            ret.append("Q");
        }
        return ret.toString();
    }

    public String getNumberString() {
        StringBuilder ret = new StringBuilder();
        if (this.getParent() != null) {
            ret.append(this.getParent().getNumberString()).append("-");
        }
        return ret.append(super.getNumberString()).toString();
    }

    public int getNumberType() {
        return -2;
    }

    public int getResourceIndex() {
        return -2;
    }

    protected void initInConnectors() {
        this.fInConnectors = new InBlockConnector[1];
    }

    protected void initOutConnectors() {
        this.fOutConnectors = new OutBlockConnector[1];
    }

    public double calculateAnalogValue() {
        return ((AnalogInBlockConnector)this.fInConnectors[0]).calculateAnalogValue();
    }

    protected boolean calculateBinaryValue() {
        return ((BinaryInBlockConnector)this.fInConnectors[0]).calculateBinaryValue();
    }

    public void setParent(UDFBlock udfBlock) {
        this.fUDFBlock = udfBlock;
    }

    public UDFBlock getParent() {
        return this.fUDFBlock;
    }

    public void setBinaryAnalogType(int type) {
        if (type == 0) {
            this.fInConnectors[0] = new BinaryInBlockConnector((Block)this, false);
            this.fOutConnectors[0] = new BinaryOutBlockConnector(this);
        } else {
            this.fInConnectors[0] = new AnalogInBlockConnector((Block)this, 0.0);
            this.fOutConnectors[0] = new AnalogOutBlockConnector(this);
        }
    }

    public int getBinaryAnalogType() {
        return this.fInConnectors[0].getSignalType();
    }

    public void setInconnector(InBlockConnector inConnector) {
        this.fInConnectors[0] = inConnector;
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(this.fUDFBlock);
        dw.writeBoolean(this.fIsInputType);
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fUDFBlock = (UDFBlock)dr.readStorable();
        this.setInputType(dr.readBoolean());
    }

    public int getOpcode() throws RuntimeException {
        return ((Logo7)this.getHardware()).getUDFRelatedOpcode(this.getName());
    }

    public int getOpcode(Hardware hw, int blockNr) throws IllegalArgumentException {
        return ((Logo7)hw).getUDFRelatedOpcode(this.getName());
    }

    public boolean isInputType() {
        return this.fIsInputType;
    }

    public void setInputType(boolean isInputType) {
        this.fIsInputType = isInputType;
    }

    public void setNumber(int newNumber) {
        this.fBlockNumber = newNumber;
    }

    public int getIndexOfParentUDF() {
        int i;
        UDFBlock parent = this.getParent();
        DeputyBlock[] inDeputies = parent.getInputDeputies();
        DeputyBlock[] outDeputies = parent.getOutputDeputies();
        for (i = 0; i < inDeputies.length; ++i) {
            if (inDeputies[i] != this) continue;
            return i;
        }
        for (i = 0; i < outDeputies.length; ++i) {
            if (outDeputies[i] != this) continue;
            return i;
        }
        return -1;
    }

    public boolean compareTo(Block otherBlock, DifferenceTableModel differences) {
        boolean result = true;
        if (this.getClass() != otherBlock.getClass()) {
            String[] str = new String[]{Language.getString("compare.differentBlockType", "Different Blocktype"), this.getLocalizedName(true), otherBlock.getLocalizedName(true)};
            Object[] o = new Object[]{this, otherBlock};
            differences.add(str, o);
            return false;
        }
        return result;
    }

    public void addMeasurementBoundsChangedListener(ParameterSetListener listener) {
    }

    public void collectSensors(List sensorContainer) {
    }

    public void removeMeasurementBoundsChangedListener(ParameterSetListener listener) {
    }
}

